import math
import numpy as np
import random
import matplotlib.pyplot as plt

def pull_arm(i,a,mu):
    X = random.uniform(0, 1)
    if X < mu[i][a]:
        return 1
    else:
        return 0

def CI(i,k,t,N,n,alpha_1):
    C = (2*N*math.log(t)/n[i][k])**0.5 + alpha_1
    return C

def ArgMaxK(Q,agent,M):
    a_i = 0
    for arm in range(M):
        if Q[agent][arm]>Q[agent][a_i]:
            a_i = arm
    return a_i

def RandomSelect(A,agent):
    random_num = random.randint(0, len(A[agent])-1)
    return random_num

def GossipUCB(N,M,alpha1,T,mu,Neighbor,best_arm):
    mu_star = np.mean(mu, axis=0)
    lamda2 = 0.5759
    X_tilde = np.zeros((N,M,2)) # [sum of reward , pull times]
    n = np.zeros((N,M))    #number of pull
    sita = np.zeros((N,M))    #estimation of the global value
    X = np.zeros((N,M))           #local reward
    n_tilde = np.zeros((N, M))    #max number of the agent to pull the arm
    sum_reward = np.zeros((N, M))
    sum_pull_time = np.zeros((N, M))
    regret_list = [[0],[0],[0],[0],[0],[0],[0],[0]]


    # 1 Initialization
    """for agent in range(N):
        for arm in range(M):
            X[agent][arm] = pull_arm(agent,arm,mu)
            X_tilde[agent][arm][0] += X[agent][arm]
            X_tilde[agent][arm][1] += 1
            sita[agent][arm] = X[agent][arm]
            n[agent][arm] = 1
            n_tilde[agent][arm] = 1
"""
    # Initialization
    for agent in range(N):
        for arm in range(M):
            # X[agent][arm] = pull_arm(agent, arm, mu)
            X[agent][arm] = mu[agent][arm]
            X_tilde[agent][arm][0] += X[agent][arm]
            X_tilde[agent][arm][1] += 1
            sita[agent][arm] = X[agent][arm]
            n[agent][arm] = 1
            n_tilde[agent][arm] = 1
            #sum_reward[agent][arm] += X[agent][arm]
            #sum_pull_time[agent][arm] += 1
            #regret_list[agent].append((regret_list[agent][-1] + mu_star[best_arm] - mu_star[arm]))



    for t in range(1,T+1):  # T
        A = [set() for _ in range(N)]

        new_n_tilde = np.zeros((N, M))
        for agent in range(N):
            for arm in range(M):
                #line 5
                for nei in Neighbor[agent]:
                    new_n_tilde[agent][arm] = max(n_tilde[nei][arm], n[agent][arm], new_n_tilde[agent][arm])        #计算arm被哪个agentpull的次数最多


        for agent in range(N):
            for arm in range(M):
                #line 6
                if n[agent][arm] < n_tilde[agent][arm] - N:
                    A[agent].add(arm)

        n_tilde = new_n_tilde

        a = np.zeros(N)
        Q = np.zeros((N, M))
        for agent in range(N):
            if not A[agent]:
                for arm in range(M):
                    #line 9
                    Q[agent][arm] = sita[agent][arm] + CI(agent,arm,t,N,n,alpha1)
                    #line 10
                a[agent] = ArgMaxK(Q,agent,M)
            else:
                #print(A[agent])
                #print(RandomSelect(A,agent))
                a[agent] = list(A[agent])[RandomSelect(A,agent)]
                #print("t:",t,"a[agent]:",a[agent])

        X_tilde_old = np.zeros((N,M))
        for agent in range(N):
            for arm in range(M):
                X_tilde_old[agent][arm] =  X_tilde[agent][arm][0] / X_tilde[agent][arm][1]
        for agent in range(N):
            X[agent][int(a[agent])] = pull_arm(agent, int(a[agent]), mu)
            X_tilde[agent][int(a[agent])][0] += X[agent][int(a[agent])]
            X_tilde[agent][int(a[agent])][1] += 1

            sum_reward[agent][int(a[agent])] += X[agent][int(a[agent])]
            sum_pull_time[agent][int(a[agent])] += 1
            regret_list[agent].append((regret_list[agent][-1] + mu_star[best_arm] - mu_star[int(a[agent])]))

        for agent in range(N):
            n[agent][int(a[agent])] += 1

        random_x = random.uniform(0, 1)

        new_sita = np.zeros((N,M))
        for i in range(N):
            gossip_agent = random.choice(Neighbor[i])
            for k in range(M):
                new_sita[i][k] = (sita[i][k]+sita[gossip_agent][k])/2 + X_tilde[i][k][0]/X_tilde[i][k][1] - X_tilde_old[i][k]
        sita = new_sita
    return regret_list

def GOS():
    N = 8
    M = 10
    alpha1 = 64 / (N ** 17)
    mu = np.array([
        [0.1, 0.1, 0.1, 0.1, 0.85, 0.8, 0.7, 0.65, 0.75, 0.75],
        [0.7, 0.6, 0.2, 0.1, 0.7, 0.2, 0.3, 0.5, 0.1, 0.4],
        [0.3, 0.3, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.6, 0.6],
        [0.6, 0.5, 0.7, 0.3, 0.85, 0.1, 0.6, 0.6, 0.3, 0.3],
        [0.1, 0.6, 0.1, 0.2, 0.85, 0.3, 0.3, 0.5, 0.3, 0.2],
        [0.5, 0.7, 0.1, 0.1, 0.9, 0.7, 0.6, 0.5, 0.3, 0.6],
        [0.4, 0.5, 0.1, 0.1, 0.7, 0.8, 0.3, 0.7, 0.1, 0.5],
        [0.3, 0.4, 0.6, 0.1, 0.75, 0.7, 0.5, 0.4, 0.2, 0.3]
    ])

    mu8 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6],
        [0.8, 0.6, 0.7, 0.1, 0.6, 0.2, 0.3, 0.5],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.6, 0.6, 0.5],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.6, 0.3, 0.7],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4]
    ])

    mu9 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6],
        [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6],
        [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7],
        [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7],
        [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7],
        [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7],
        [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7],
        [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6]
    ])


    mu10 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6, 0.6, 0.9],
        [0.8, 0.6, 0.7, 0.1, 0.6, 0.2, 0.3, 0.5, 0.6, 0.7],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7, 0.7, 0.7],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6, 0.7, 0.2],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5, 0.7, 0.2],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.6, 0.6, 0.5, 0.7, 0.2],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.6, 0.3, 0.7, 0.7, 0.9],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4, 0.6, 0.5]
    ])

    # mu10 = np.array([
    #     [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9],
    #     [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
    #     [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7],
    #     [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2],
    #     [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2],
    #     [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2],
    #     [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9],
    #     [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5]
    # ])

    mu11 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7],
        [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6, 0.7, 0.2, 0.3],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8]
    ])

    mu12 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6],
        [0.8, 0.6, 0.7, 0.1, 0.6, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.6, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.6, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1]
    ])

    # mu12 = np.array([
    #     [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6],
    #     [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7],
    #     [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4],
    #     [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5],
    #     [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5],
    #     [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5],
    #     [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6],
    #     [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1]
    # ])

    mu13 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4],
        [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2],
        [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8],
        [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6],
        [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6],
        [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6],
        [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5],
        [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4]
    ])

    mu14 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4, 0.5],
        [0.8, 0.6, 0.7, 0.1, 0.6, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8, 0.4],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.6, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.6, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4, 0.3]
    ])

    # mu14 = np.array([
    #     [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4, 0.5],
    #     [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3],
    #     [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8, 0.4],
    #     [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
    #     [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
    #     [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7],
    #     [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7],
    #     [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4, 0.3]
    # ])

    mu15 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4, 0.5, 0.6],
        [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5],
        [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5],
        [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1],
        [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1],
        [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.9],
        [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.9],
        [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4, 0.3, 0.4]
    ])

    mu16 = np.array([
        [0.9, 0.6, 0.8, 0.8, 0.6, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4, 0.5, 0.6, 0.6],
        [0.8, 0.6, 0.7, 0.1, 0.6, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.5],
        [0.7, 0.7, 0.6, 0.4, 0.6, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.5],
        [0.8, 0.8, 0.6, 0.3, 0.6, 0.6, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.1],
        [0.7, 0.8, 0.8, 0.2, 0.6, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.1],
        [0.9, 0.9, 0.6, 0.7, 0.6, 0.6, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.9, 0.4],
        [0.8, 0.6, 0.9, 0.7, 0.6, 0.6, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.9, 0.4],
        [0.8, 0.6, 0.6, 0.7, 0.6, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4, 0.3, 0.4, 0.4]
    ])

    # mu16 = np.array([
    #     [0.9, 0.6, 0.8, 0.8, 0.8, 0.8, 0.7, 0.6, 0.6, 0.9, 0.7, 0.6, 0.4, 0.5, 0.6, 0.6],
    #     [0.8, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.7, 0.2, 0.3, 0.5, 0.5],
    #     [0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.7, 0.7, 0.6, 0.4, 0.8, 0.4, 0.5, 0.5],
    #     [0.8, 0.8, 0.6, 0.3, 0.8, 0.9, 0.6, 0.6, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.1],
    #     [0.7, 0.8, 0.8, 0.2, 0.8, 0.3, 0.3, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.1, 0.1],
    #     [0.9, 0.9, 0.6, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.2, 0.3, 0.5, 0.6, 0.7, 0.9, 0.4],
    #     [0.8, 0.6, 0.9, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.9, 0.7, 0.6, 0.5, 0.7, 0.9, 0.4],
    #     [0.8, 0.6, 0.6, 0.7, 0.7, 0.7, 0.5, 0.4, 0.6, 0.5, 0.8, 0.1, 0.4, 0.3, 0.4, 0.4]
    # ])

    T = int(1e4)
    Neighbor = np.array([[1, 2, 6, 7],
                         [0, 2, 3, 7],
                         [0, 1, 3, 4],
                         [1, 2, 4, 5],
                         [2, 3, 5, 6],
                         [3, 4, 6, 7],
                         [0, 4, 5, 7],
                         [0, 1, 5, 6]])
    best_arm = 0
    repeated_time = 10

    regret_list_zero_8 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, 8, alpha1, T, mu8, Neighbor, best_arm)
        regret_list_zero_8.append(regret_list[0][-1])
    print(regret_list_zero_8)

    regret_list_zero_10 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, 10, alpha1, T, mu10, Neighbor, best_arm)
        regret_list_zero_10.append(regret_list[0][-1])
    print(regret_list_zero_10)

    regret_list_zero_12 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, 12, alpha1, T, mu12, Neighbor, best_arm)
        regret_list_zero_12.append(regret_list[0][-1])
    print(regret_list_zero_12)

    regret_list_zero_14 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, 14, alpha1, T, mu14, Neighbor, best_arm)
        regret_list_zero_14.append(regret_list[0][-1])
    print(regret_list_zero_14)

    regret_list_zero_16 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, 16, alpha1, T, mu16, Neighbor, best_arm)
        regret_list_zero_16.append(regret_list[0][-1])
    print(regret_list_zero_16)

    regret_list_zero_np_8 = np.array(regret_list_zero_8)
    regret_mean_8 = np.mean(regret_list_zero_np_8)
    regret_std_8 = np.std(regret_list_zero_np_8)

    regret_list_zero_np_10 = np.array(regret_list_zero_10)
    regret_mean_10 = np.mean(regret_list_zero_np_10)
    regret_std_10 = np.std(regret_list_zero_np_10)

    regret_list_zero_np_12 = np.array(regret_list_zero_12)
    regret_mean_12 = np.mean(regret_list_zero_np_12)
    regret_std_12 = np.std(regret_list_zero_np_12)

    regret_list_zero_np_14 = np.array(regret_list_zero_14)
    regret_mean_14 = np.mean(regret_list_zero_np_14)
    regret_std_14 = np.std(regret_list_zero_np_14)

    regret_list_zero_np_16 = np.array(regret_list_zero_16)
    regret_mean_16 = np.mean(regret_list_zero_np_16)
    regret_std_16 = np.std(regret_list_zero_np_16)

    # for i in range(len(regret_mean)):

    regret_list_G = [regret_mean_8,regret_mean_10,regret_mean_12,regret_mean_14,regret_mean_16]


    # 显示图表
    #plt.show()
    #plt.plot([8,10,12,14,16], regret_list_G, '-^', color='blue', markerfacecolor='none', markersize=10)
    #plt.fill_between([8,10,12,14,16], [regret_mean_8-regret_std_8,regret_mean_10-regret_std_10,regret_mean_12-regret_std_12,regret_mean_14-regret_std_14,regret_mean_16-regret_std_16], [regret_mean_8+regret_std_8,regret_mean_10+regret_std_10,regret_mean_12+regret_std_12,regret_mean_14+regret_std_14,regret_mean_16+regret_std_16], color='lightblue',alpha=0.7)

    #plt.grid(True, linestyle='--')
    # plt.title('regret')
    #plt.xlabel('time')
    #plt.ylabel('average regret of each agent')
    #plt.legend()
    #plt.show()
    return (regret_list_G, [regret_mean_8-regret_std_8,regret_mean_10-regret_std_10,regret_mean_12-regret_std_12,regret_mean_14-regret_std_14,regret_mean_16-regret_std_16], [regret_mean_8+regret_std_8,regret_mean_10+regret_std_10,regret_mean_12+regret_std_12,regret_mean_14+regret_std_14,regret_mean_16+regret_std_16])